#include <analysis.h>
#include <cvirte.h>		
#include <userint.h>
#include "graf2.h"
static double faza;

static int panelHandle;

int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "graf2.uir", PANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}

int CVICALLBACK Koniec (int panel, int event, void *callbackData,
		int eventData1, int eventData2)
{
	switch (event)
	{
		case EVENT_GOT_FOCUS:

			break;
		case EVENT_LOST_FOCUS:

			break;
		case EVENT_CLOSE:
			QuitUserInterface (0);

			break;
	}
	return 0;
}

int CVICALLBACK Generuj (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	double signal[500];
	int tvar;
	double frekv;
	double ampl;
	switch (event)
	{
		case EVENT_COMMIT:
			GetCtrlVal (panelHandle, PANEL_AMPL, &ampl);
			GetCtrlVal (panelHandle, PANEL_TVAR, &tvar);
			GetCtrlVal (panelHandle, PANEL_FREQ, &frekv);
			switch (tvar)
			{
				case 0:
					SineWave (500, ampl, frekv/500, &faza, signal);
					
					break;
				case 1:
					TriangleWave (500, ampl, frekv/500, &faza, signal);
					
					
					break;
				case 2:
					SawtoothWave (500, ampl, frekv/500, &faza, signal);  
					break;
				case 3:
					SquareWave (500, ampl, frekv/500, &faza, 50.0, signal);
					
					break;
				default:
					
					break;
			}
			DeleteGraphPlot (panelHandle, PANEL_GRAPH, -1, VAL_IMMEDIATE_DRAW);
			
			PlotWaveform (panelHandle, PANEL_GRAPH, signal, 500, VAL_DOUBLE, 1.0,
						  0.0, 0.0, 1.0, VAL_FAT_LINE, VAL_EMPTY_SQUARE,
						  VAL_SOLID, 1, VAL_YELLOW);

			break;
	}
	return 0;
}
